/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	CollectionScene
**
** DESCRIPTION:	Collection scene displays items which have been collected
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef THE_COLLECTION_SCENE_H
#define THE_COLLECTION_SCENE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwScene.h"
#include "ldwButton.h"
#include "ldwTextControl.h"
#include "../Game/Tech.h"
#include "../Utils/theGraphicsManager.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CCollectionScene : public ldwScene
{
private:

	//class enumerations
	enum EButton
	{
		eButton_Done = 0,

/*		eButton_ScienceBuy,
		eButton_MedicineBuy,
		eButton_AlchemyBuy,
		eButton_RestorationBuy,
		eButton_FarmingBuy,
		eButton_NatureBuy,
		eButton_MagicBuy,

		eButton_ScienceInfo,
		eButton_MedicineInfo,
		eButton_AlchemyInfo,
		eButton_RestorationInfo,
		eButton_FarmingInfo,
		eButton_NatureInfo,
		eButton_MagicInfo,
*/
		eButton_NumberOf
	};

	//class structures
	struct SCollectable
	{
		EImage				m_eImage;
		int					m_iXPos;
		int					m_iYPos;
	};

	//class data
	static CCollectionScene *	m_pInstance;
	static SCollectable			sm_sCollectable[4 * 12];

	ldwButton *				m_pButton[eButton_NumberOf];
	ldwTextControl *		m_pSceneLabel;
	ldwTextControl *		m_pPlayerCommField;
	ldwTextControl *		m_pCollectionLabel[5];
	ldwTextControl *		m_pCollectionProgress[5];

	//class methods
	//setup
	private:	CCollectionScene();
	private:	~CCollectionScene();
	public:		static CCollectionScene *Get();
	public:		static CCollectionScene &Ref();
	public:		static void Destroy();

	//prevent copy
	public:		CCollectionScene(const CCollectionScene &);
	public:		CCollectionScene & operator = (const CCollectionScene &);

	//process
	protected:	void Activate(bool bIsActive);
	protected:	void UpdateScene();
	protected:	void DrawScene();
	public:		bool HandleKey(int iMessageID, int iKeyCode, int iCharacter);
	public:		bool HandleMessage(int iMessageID, long iData);
	public:		bool HandleMouse(int iMessageID, ldwPoint sMousePos);

	//access
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/